import { model, Schema } from "mongoose";

const biolinkSchema = new Schema(
  {
    user: {
      type: Schema.Types.ObjectId,
      ref: "User",
      required: true,
    },
    username: {
      type: String,
      required: true,
      unique: true,
    },
    name: {
      type: String,
      required: false,
    },
    profilePicture: {
      type: Schema.Types.ObjectId,
      ref: "Media",
      required: false,
    },
    bio: {
      type: String,
      required: false,
    },
    links: [
      {
        type: Schema.Types.ObjectId,
        ref: "Link",
      },
    ],
  },
  {
    timestamps: true,
  }
);

export default model("Biolink", biolinkSchema);
